/*******************************************************
Filename		:  db_seq.sql
Release 		:  c2.0
SIR			:  1366
Description		:  Create sequences for drianage basin dimension tables.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
Comments		:  11/26/2002 - Droped lu_geo_country table and its associations. G.Thadkamalla.
	06/10/2003 - consolidate 4 difference files into 1 and update from storet v2.0
	01/16/04 - SIR 1586 Moved connect string to master install script -JW
 	06/07/2005 - SIR 1706.  Add Generated_HUC and related constraints.	
**********************************************************/

set echo on
spool db_tables.log

drop sequence seq_db_cat;
create sequence seq_db_cat
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table DI_DB_cat;

--HYDROLOGIC UNITs/ CatUnits

create table DI_DB_cat
(pk_isn number(12,0),
 hydrologic_unit_code char(8) not null,
 hydrologic_unit_name varchar2(200));

alter table DI_DB_cat
add constraint pk_db_cat primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial 100K next 100K)
nologging;

create unique index db_cat02 on DI_DB_cat(hydrologic_unit_code)
tablespace STORETINDX
storage(initial 100K next 100K)
nologging;

-- cat
delete from  di_db_cat;
commit;

insert into di_db_cat(PK_ISN,hydrologic_UNIT_CODE,hydrologic_UNIT_NAME)
	select seq_db_cat.nextval,rtrim(hydrologic_unit_cd),name from storet.tsmfhu;
commit;

alter table fa_station
add (fk_db_cat number(12,0),
     fk_gen_db_cat number(12,0));

alter table fa_station 
add constraint fk_sd_db_cat foreign key (fk_db_cat) references di_db_cat(pk_isn);

alter table fa_station 
add constraint fk_sd_gen_db_cat foreign key (fk_gen_db_cat) references di_db_cat(pk_isn);


update fa_station sd
set sd.fk_db_cat = (select distinct C.pk_isn from di_db_cat C
                   where C.HYDROLOGIC_unit_code = substr(sd.HYDROLOGIC_UNIT_CODE,1,8)),
    sd.fk_gen_db_cat = (select distinct C.pk_isn from di_db_cat C
                   where C.HYDROLOGIC_unit_code = substr(sd.HYDROLOGIC_UNIT_CODE,1,8))
where sd.HYDROLOGIC_UNIT_CODE is not null;
commit;

create index isd_db4 on fa_station(fk_db_cat)
tablespace STORETINDX
storage(initial 500k next 500k)
nologging;

create index isd_gen_db4 on fa_station(fk_gen_db_cat)
tablespace STORETINDX
storage(initial 500k next 500k)
nologging;


spool off;